// Global Variables
var gbLoggedIn = false; // initially, the user is not logged in
var vKeys=[]; // an array of vKeys, one of which must be submitted with every 'Post' request
var curvKey = getRandomInt(0, 9); // need to keep track of which vKey you are using
var pwSeed = '' // Required for changing password
var defaultServer="https://fcws.YourFCWSServer.com";
var defaultPort="443"; // must be 443 if you want to be able to change password
var ServerAddr = defaultServer + ":" + defaultPort;
var fcData;

$(function () {
	// Once the DOM is loaded, we can accept logins
	$('#LI_Server').html(defaultServer);
	$('#LI_Port').html(defaultPort);
	$("#ResponseBody").html('Waiting.....');
	$("#LI_LOGIN").click(function () {
		loginLogoff();
		return false;       
	});
	$("#SubmitData").click(function () {
		$("#ResponseBody").html('');
		GetURL = ServerAddr + $('#queryField').val();
		var openItem = openObject(GetURL)
		openItem.done(function (data, textStatus, jqXHR){
			if (JSON.stringify(data,null, 4) != undefined) {
				fcData = data;
				var vkeysObj = fcData.VKEYS;
				var dataReceived = FIRSTCLASS.util.escapeHTML(JSON.stringify(fcData,null, 4));
				// Replenish vKey if one received.
				if (vkeysObj) {
					alert('vKey replaced');
					vKeys[curvKey] = vkeysObj[0].vkey
					// generate another random number for the curvKey (not really necessary)
					curvKey = getRandomInt(0, 9)
				}			
			} else {
				var dataReceived = 'No data returned';
			}
			
			$("#ResponseBody").html('fcData = ' + dataReceived);
		})
		return false;       
	});

	$('#queryField').change(function () {
		// Checks to see if [vKey] is in the field and if so, replace with current vKey value
		var txt = $('#queryField').val();
		if (txt.indexOf("[vkey]") != -1) {
			txt = txt.replace('[vkey]',vKeys[curvKey]);
			$('#queryField').val(txt);
		}         
	});
});


function loginLogoff(){
	var dataSent = '';
	if (gbLoggedIn){
		// We are logged in, so we must want to log off
		dataSent = 'JSON={"logoff":1}&VKey=' + vKeys[curvKey];
	}
	else {
		// encrypt the password and login
		var userid = $("#LI_name").val().toUpperCase();
		var pw = $("#LI_pw").val();
		var sha512 = CryptoJS.algo.SHA512.create();
		sha512.update(userid);
		sha512.update(pw);
		var sha512Result = sha512.finalize().toString();
		var base64Result = base64.encode(sha512Result);
		pw = base64Result;
		// Submit encrypted credentials
		dataSent = 'JSON={"login":{"userid":"' + userid + '","sha512digest":"' + pw + '","language":"en"}}';
	}
	// Now that we have the required information, submit the AJAX call
	$.ajax({
		url:ServerAddr + "/?ReplyAsJSON",
		type:"GET",
		data:dataSent,
		crossDomain: true,
		dataType: 'jsonp',
		success: function(data, textStatus, jqXHR) {
			fcData = data;
			$('#ResultsContainer').show();
			// console.log(data);
			var dataReceived = FIRSTCLASS.util.escapeHTML(JSON.stringify(fcData,null, 4));
			var errorObj = fcData.ERROR;
			gbLoggedIn = fcData.LOGINREPLY !== undefined;
			if (gbLoggedIn) {
				// Getting vKeys are only required if you are going to be updating information on the server and logging out
				for (var i = 0; i < 10; i++) {
					vKeys[i]=fcData.LOGINREPLY.VKEYS[i].vkey;
				};
				// the pwSeed is required only if you are going to change the password in your requests
				pwSeed = fcData.LOGINREPLY.pwSeed;
				// Successfull, so change Login button to 'Log off'
					$("#LI_LOGIN").text("Log Off");
					$('#GetPostData').show();
				// Hide the credential entry fields
					$("#LI_Entry").hide();
			}
			else if (errorObj) {
				// There was some problem logging in so handle the error code here
			}
			else { // Must be a successfull logoff
				$("#LI_LOGIN").text("Login");
				$('#GetPostData').hide();
				$("#LI_Entry").show();
			}
			// Display the results of the data received from the server
			$("#ResponseBody").html('fcData = ' + dataReceived);	

		},
		error: function(data, textStatus, jqXHR) {
			// There is an error so report it.
			$('#ResponseBody').html("Error Status: " + textStatus + "<br />" + jqXHR);
			gbLoggedIn=false;
		}
	});
}

function openObject(GetURL) {
	return $.ajax({ 
		url:GetURL,
		type:"GET",
		crossDomain: true,
		dataType: 'jsonp',
		success: function(data, textStatus, jqXHR) {
			// data will be returned
		},
		error: function(data, textStatus, jqXHR) {
			// console.log(data);
			alert("Error Retrieving JSON\ntextStatus:" + textStatus + "\nqXHR:" + jqXHR);
		}
	});
}